/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.tooltip;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.mantle.fluid.tooltip.FluidUnit;
import slimeknights.mantle.fluid.tooltip.FluidUnitList;

public abstract class AbstractFluidTooltipProvider
extends GenericDataProvider {
    private final Map<class_2960, class_2960> redirects = new HashMap<class_2960, class_2960>();
    private final Map<class_2960, FluidUnitListBuilder> builders = new HashMap<class_2960, FluidUnitListBuilder>();
    private final String modId;

    public AbstractFluidTooltipProvider(FabricDataOutput generator, String modId) {
        super(generator, class_3264.field_14188, "mantle/fluid_tooltips", FluidTooltipHandler.GSON);
        this.modId = modId;
    }

    protected abstract void addFluids();

    public final CompletableFuture<?> method_10319(class_7403 cache) {
        this.addFluids();
        ArrayList futures = new ArrayList();
        this.builders.forEach((key, builder) -> futures.add(this.saveThing(cache, (class_2960)key, builder.build())));
        this.redirects.forEach((key, target) -> {
            JsonObject json = new JsonObject();
            json.addProperty("redirect", target.toString());
            futures.add(this.saveThing(cache, (class_2960)key, json));
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected class_2960 id(String name) {
        return new class_2960(this.modId, name);
    }

    protected FluidUnitListBuilder add(class_2960 id, @Nullable class_6862<class_3611> tag) {
        if (this.redirects.containsKey(id)) {
            throw new IllegalArgumentException(String.valueOf(id) + " is already registered as a redirect");
        }
        FluidUnitListBuilder newBuilder = new FluidUnitListBuilder(tag);
        FluidUnitListBuilder original = this.builders.put(id, newBuilder);
        if (original != null) {
            throw new IllegalArgumentException(String.valueOf(id) + " is already registered");
        }
        return newBuilder;
    }

    protected FluidUnitListBuilder add(String id, class_6862<class_3611> tag) {
        return this.add(this.id(id), tag);
    }

    protected FluidUnitListBuilder add(class_6862<class_3611> tag) {
        return this.add(this.id(tag.comp_327().method_12832()), tag);
    }

    protected FluidUnitListBuilder add(class_2960 id) {
        return this.add(id, null);
    }

    protected FluidUnitListBuilder add(String id) {
        return this.add(this.id(id), null);
    }

    protected void addRedirect(class_2960 id, class_2960 target) {
        if (this.builders.containsKey(id)) {
            throw new IllegalArgumentException(String.valueOf(id) + " is already registered as a unit list");
        }
        class_2960 original = this.redirects.put(id, target);
        if (original != null) {
            throw new IllegalArgumentException(String.valueOf(id) + " is already redirecting to " + String.valueOf(original));
        }
    }

    protected class FluidUnitListBuilder {
        @Nullable
        private final class_6862<class_3611> tag;
        private final ImmutableList.Builder<FluidUnit> units = ImmutableList.builder();

        public FluidUnitListBuilder addUnitRaw(String key, long amount) {
            this.units.add((Object)new FluidUnit(key, amount));
            return this;
        }

        public FluidUnitListBuilder addUnit(String key, long amount) {
            return this.addUnitRaw(class_156.method_646((String)"gui", (class_2960)AbstractFluidTooltipProvider.this.id("fluid." + key)), amount);
        }

        public FluidUnitListBuilder addUnit(String key, String domain, long amount) {
            return this.addUnitRaw(class_156.method_646((String)"gui", (class_2960)new class_2960(domain, "fluid." + key)), amount);
        }

        private FluidUnitList build() {
            return new FluidUnitList(this.tag, (List<FluidUnit>)this.units.build());
        }

        private FluidUnitListBuilder(class_6862<class_3611> tag) {
            this.tag = tag;
        }
    }
}

